<?php
/**
 * Interface for MCP observability handlers.
 *
 * @package McpAdapter
 */

declare( strict_types=1 );

namespace WP\MCP\Infrastructure\Observability\Contracts;

/**
 * Interface for handling MCP observability metrics and tracking.
 *
 * This interface defines the contract for observability handlers that can
 * track metrics like request counts, timing, and error rates in the MCP adapter.
 * Concrete implementations can integrate with various observability systems.
 */
interface McpObservabilityHandlerInterface {

	/**
	 * Emit a countable event for tracking with optional timing data.
	 *
	 * @param string     $event The event name to record.
	 * @param array      $tags Optional tags to attach to the event.
	 * @param float|null $duration_ms Optional duration in milliseconds for timing measurements.
	 *
	 * @return void
	 */
	public function record_event( string $event, array $tags = array(), ?float $duration_ms = null ): void;
}
