import { StatusIcon } from '@ithemes/security-ui';

function getVulnerabilityStatus( vulnerability ) {
	switch ( vulnerability.resolution.slug ) {
		case '':
			return 'attention';
		case 'auto-updated':
		case 'deactivated':
		case 'deleted':
		case 'updated':
			return 'resolved';
		case 'patched':
			return 'mitigated';
		default:
			return undefined;
	}
}
export default function VulnerabilityStatusIcon( { vulnerability } ) {
	const status = getVulnerabilityStatus( vulnerability );
	if ( ! status ) {
		return null;
	}

	return <StatusIcon status={ status } />;
}
